﻿using System;
using System.Collections.Generic;
using System.Text;
using CIA_CSS;
using CSS_User;
using System.Windows.Forms;
using IndianHealthService.BMXNet.Services;
using IndianHealthService.BMXNet.EHR.Model;

namespace IndianHealthService.BMXNet.EHR
{
    internal class BMXNetEhrBroker : BMXNetBroker, BMXNetSessionConnectionSource
    {
        public static BMXNetEhrBroker Open(ICSS_Session aCiaSession, ICSS_User aCiaUser, IndianHealthService.BMXNet.Model.User aUser)
        {
            CiaVisit.InitialzeAccessToCSSEncounter();

            BMXNetEhrBroker broker = new BMXNetEhrBroker();
            if (broker.OpenOn(aCiaSession, aCiaUser,aUser))
            {
                return broker;
            }
            else
            {
                throw new BMXNetException("Unable to connection BMX to EHR session.");
            }
        }

        private ICSS_Session _ciaSession = null;

        public ICSS_Session CiaSession
        {
            get { return _ciaSession; }
            set { _ciaSession = value; }
        }

        private ICSS_User _ciaUser = null;

        public ICSS_User CiaUser
        {
            get { return _ciaUser; }
            set { _ciaUser = value; }
        }


        internal bool OpenOn(ICSS_Session aCiaSession, ICSS_User aCiaUser, IndianHealthService.BMXNet.Model.User aUser)
        {
            this.CiaSession = aCiaSession;
            this.CiaUser = aCiaUser;
            this.User = aUser;
            this.SessionPool = this.CreateRemoteSessionPool(this, 1);
            this.PrimarySession = this.SessionPool.OpenSession(this.Log);
            return this.PrimaryRemoteSession != null;
        }


        private RemoteSessionPool _sessionPool = null;

        public RemoteSessionPool SessionPool
        {
            get { return _sessionPool; }
            set { _sessionPool = value; }
        }



        public override bool IsConnected
        {
            get { throw new NotImplementedException(); }
        }

        public override void Close()
        {
            //Do nothing.  Can't close this broker
        }

        private RemoteSession _primarySession = null;

        internal RemoteSession PrimarySession
        {
            get { return _primarySession; }
            set { _primarySession = value; }
        }


        public override RemoteSession PrimaryRemoteSession
        {
            get { return this.PrimarySession; }
        }

        public override RemoteSessionPool RemoteSessionPool
        {
            get { return this.SessionPool; }
        }


        BMXNetSessionConnection BMXNetSessionConnectionSource.OpenConnection()
        {
            return BMXNetEhrSessionConnection.OpenOn(this,this.CiaSession, this.CiaUser);
        }

        void BMXNetSessionConnectionSource.CloseConnection(BMXNetSessionConnection aConnection)
        {
            //Do nothing.  We don't close the primary connection
        }


    }
}

